# 🚀 Tenant Referral Program - Shortcode Usage Guide

## ✅ Correct Shortcode Names

### Signup Form Shortcode
**Correct**: `[tenant_referral_signup]`  
**❌ Incorrect**: `[tenant_referral_signup_form]`

### Widget Shortcode  
**Correct**: `[tenant_referral_widget]`

---

## 📋 Quick Testing Steps

### 1. Basic Signup Form
Replace the text in your WordPress page/post with:
```
[tenant_referral_signup]
```

### 2. Custom Title
```
[tenant_referral_signup title="Join Our Community"]
```

### 3. Hide Title
```
[tenant_referral_signup show_title="no"]
```

---

## 🔧 Troubleshooting

### If shortcode shows as plain text:
1. **Check shortcode name**: Use `[tenant_referral_signup]` not `[tenant_referral_signup_form]`
2. **Verify plugin is active**: Go to Plugins → Installed Plugins
3. **Check for PHP errors**: Look in WordPress admin for error notices
4. **Test with default theme**: Temporarily switch to Twenty Twenty-Four theme

### If form doesn't appear:
1. Check browser console for JavaScript errors
2. Verify Settings → Referral Program is configured
3. Try adding `debug="yes"` to test: `[tenant_referral_widget debug="yes"]`

---

## 🎯 Expected Behavior

When working correctly, you should see:
- ✅ A styled signup form with email, password, phone, address fields
- ✅ Referral code detection from URL parameters (`?ref_code=TEST123`)
- ✅ Manual referral code entry area
- ✅ AJAX form submission without page reload
- ✅ Success/error messages after form submission

---

## 📞 Quick Test

1. **Replace your current shortcode** with: `[tenant_referral_signup]`
2. **Save the page**
3. **View the page** - you should see the full signup form
4. **Test with referral code**: Add `?ref_code=TEST123` to the URL

The form should show: *"Referral code TEST123 will be applied."* 